<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreConfrontoImmagini extends VisualizzatoreComponente {
        private $impostazioniAspetto;
        private $altezzaSezione;
        
        function __construct($db) {
            parent::__construct($db);
            $this->impostazioniAspetto = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
        }


        function generaContenutoSezione($dati) {
            $sezione = parent::getDb()->leggiSingolaRiga("geec_confrontoImmagini",$dati["idElemento"]);
            $this->idSezione = $dati["idSezione"];
            $linkImmagine1 = $this->impostazioniAspetto["urlSito"]."/".$sezione["immagine1"];
            $linkImmagine2 = $this->impostazioniAspetto["urlSito"]."/".$sezione["immagine2"];
            
            echo"<div class=\"{$sezione['spazioOccupato']}\">
                    <div class=\"row no-gutters\">
                        <div class=\"cocoen cocoen$this->idSezione\">
                            <img src=\"$linkImmagine1\" alt=\"\">
                            <img src=\"$linkImmagine2\" alt=\"\">
                        </div>
                    </div>
                </div>";
        }
        
        function stampaSezioneConTestoADestra($sezione,$linkImmagine1,$linkImmagine2) {
            $classiDiv = explode(", ", $sezione["stile"]);
            echo"<div class=\"row no-gutters\">
                    <div class=\"cocoen {$classiDiv[1]} {$sezione["classeDivImmagine"]}\">
                        <img src=\"$linkImmagine1\" alt=\"\">
                        <img src=\"$linkImmagine2\" alt=\"\">
                    </div>
                    <div class=\"{$classiDiv[0]} d-flex align-items-center justify-content-center $this->altezzaSezione text-col {$sezione["classeDivTesto"]}\" style=\"background-color:{$sezione["coloreDivTesto"]};\">
                        <div class=\"p-5\" > 
                            {$sezione["testo"]}
                        </div>
                    </div>
                </div>";
        }
        
        function stampaSezioneConTestoASinitra($sezione,$linkImmagine1,$linkImmagine2) {
            $classiDiv = explode(", ", $sezione["stile"]);
            echo"<div class=\"row no-gutters\">";
                    echo"<div class=\"{$classiDiv[0]} d-flex align-items-center justify-content-center $this->altezzaSezione text-col {$sezione["classeDivTesto"]}\" style=\"background-color:{$sezione["coloreDivTesto"]};\">
                            <div class=\"p-5\" > 
                                {$sezione["testo"]}
                            </div>
                        </div>
                        <div class=\"cocoen {$classiDiv[1]} {$sezione["classeDivImmagine"]}\">
                            <img src=\"$linkImmagine1\" alt=\"\">
                            <img src=\"$linkImmagine2\" alt=\"\">
                        </div>
                    </div>                    
            </div>";
        }
        
        function getJavascriptAssociato() {
            return "<script src=\"plugins/cocoen/js/cocoen.min.js\"></script>
                <script src=\"plugins/cocoen/js/cocoen-jquery.min.js\"></script>

                <script>
                    document.querySelectorAll('.cocoen$this->idSezione').forEach(function(element){
                        new Cocoen(element);
                    });
                </script>";
        }
    }
